
#include <iostream>
#include <cstdio>

using namespace std;

void sayPlay()
{
  cout << "play" << endl;
}

void sayStop()
{
  cout << "stop" << endl;
}

void sayPause()
{
  cout << "pause" << endl;
}

typedef enum {
  NONE,
  STOPPED,
  PAUSED,
  STARTED
} PlayerEvent;

extern void doStart(int plFd);
extern void doStop(int plFd);
extern void doPause(int plFd);
extern PlayerEvent getEvent(int plFd);
extern int setupPlayer();

typedef enum {
  STOP,
  PAUSE,
  PLAY
} Status;

extern int select(int,int);
extern bool changed(int);
extern char getc(int);

extern void doStop(int plFd);
extern void doStart(int plFd);
void payerControl(int plFd, int uiFd)
{
  Status status = STOP;
  int ret;
  while((ret = select(plFd,uiFd)) != -1){
    switch(getc(uiFd)){
      case 'p':
        switch(status){
          case PAUSE:
            doStart(plFd);
            break;
          case PLAY:
            doPause(plFd);
            break;
          case STOP:
            break;
        }
        break;
      case 's':
        doStop(plFd);
        break;
      case 0:
        break;
    }
    switch(getEvent(plFd)){
      case STARTED:
        status = PLAY;
        sayPlay();
        break;
      case STOPPED:
        status = STOP;
        sayStop();
        break;
      case PAUSED:
        status = PAUSE;
        sayPause();
        break;
      case NONE:
        break;
    }
  }
  doStop(plFd);
}

int main()
{
  int plFd = setupPlayer();
  int uiFd = fileno(stdin);

  cout << "AcmePlayer UI" << endl;
  cout << "Control:  [p] play/pause" << endl;
  cout << "          [s] stop" << endl;

  payerControl(plFd, uiFd);

  return 0;
}
